﻿//////////////////////////////////////////////
// RelativePosition.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkMemory
{
	class StringView ;
}

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

/// Class ------------------------------------

namespace nkWinUi
{
	enum class RELATIVE_POSITION
	{
		UNKNOWN = 0,
		LEFT,
		RIGHT,
		TOP,
		BOTTOM,
		TOP_LEFT,
		TOP_RIGHT,
		BOTTOM_LEFT,
		BOTTOM_RIGHT
	} ;

	class DLL_WINUI_EXPORT RelativePositionUtils final
	{
		public :

			// String conversions
			static nkMemory::StringView enumToString (RELATIVE_POSITION toConvert) ;
			static RELATIVE_POSITION stringToEnum (nkMemory::StringView toConvert) ;

		private :

			// Constructor, destructor
			RelativePositionUtils () = delete ;
			~RelativePositionUtils () = delete ;
	} ;
}